/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.register.RegistryItems;

@ParametersAreNonnullByDefault
public abstract class FluxDeviceBlock
extends Block
implements EntityBlock {
    public FluxDeviceBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(hand).m_150930_((Item)RegistryItems.FLUX_CONFIGURATOR)) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileFluxDevice) {
            TileFluxDevice device = (TileFluxDevice)blockEntity;
            device.onPlayerInteract(player);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileFluxDevice) {
            CompoundTag tag;
            TileFluxDevice device = (TileFluxDevice)blockEntity;
            if (stack.m_41782_() && (tag = stack.m_41737_("FluxData")) != null) {
                device.readCustomTag(tag, (byte)15);
            }
            if (placer instanceof Player) {
                device.setOwnerUUID(placer.m_142081_());
            }
        }
    }
}

